//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// The master server is declared with the server defaults, which is
// loaded on both clients & dedicated servers.  If the server mod
// is not loaded on a client, then the master must be defined. 
// $pref::Master[0] = "2:master.garagegames.com:28002";

$pref::Player::Name = "Orc Shaman"; // AFX
$pref::Player::defaultFov = 90;
$pref::Player::zoomSpeed = 0;
// AFX
$pref::Player::corpsesHiddenFromRayCast = false;
$pref::afxSpellButton::unknownSpellBitmap = "arcane.fx/client/ui/icons/unknown";
$pref::afxSpellButton::spellCooldownBitmaps = "arcane.fx/client/ui/icons/cooldown/cooldown";
$pref::AFX::advancedFXLighting = !afxLegacyLighting();
$pref::AFX::fxLevelOfDetail = "2";
$pref::AFX::clickToTargetSelf = false;
$pref::AFX::targetSelectionMask = $TypeMasks::PlayerObjectType | $TypeMasks::CorpseObjectType;
$pref::AFX::missileCollisionMask = $TypeMasks::PlayerObjectType | 
                                   $TypeMasks::CorpseObjectType | 
                                   $TypeMasks::InteriorObjectType |
                                   $TypeMasks::StaticObjectType |
                                   $TypeMasks::DamagableItemObjectType |
                                   $TypeMasks::VehicleObjectType;
// AFX

$pref::Net::LagThreshold = 400;
$pref::Net::Port = 28000;
// AFX
$pref::Net::PacketRateToClient = "32";
$pref::Net::PacketRateToServer = "32";
$pref::Net::PacketSize = "450";
// AFX

$pref::shadows = "2";
$pref::HudMessageLogSize = 40;
$pref::ChatHudLength = 1;


$pref::Input::LinkMouseSensitivity = 1;
$pref::Input::MouseEnabled = 1; // AFX
$pref::Input::JoystickEnabled = 0;
$pref::Input::KeyboardTurnSpeed = 0.1;

$pref::sceneLighting::cacheSize = 20000;
$pref::sceneLighting::purgeMethod = "lastCreated";
$pref::sceneLighting::cacheLighting = 1;
$pref::sceneLighting::terrainGenerateLevel = 1;

$pref::ts::detailAdjust = 0.45;

$pref::Terrain::DynamicLights = 1;
$pref::Interior::TexturedFog = 0;

$pref::Video::displayDevice = "OpenGL";
$pref::Video::allowOpenGL = 1;
$pref::Video::allowD3D = 1;
$pref::Video::preferOpenGL = 1;
$pref::Video::appliedPref = 0;
$pref::Video::disableVerticalSync = 1;
$pref::Video::monitorNum = 0;
$pref::Video::windowedRes = "1024 768"; // Doesn't look like this is used at all...
$pref::Video::resolution = "1024 768 32";
$pref::Video::screenShotFormat = "PNG";
$pref::OpenGL::force16BitTexture = "0";
$pref::OpenGL::forcePalettedTexture = "0";
$pref::OpenGL::maxHardwareLights = 3;
$pref::VisibleDistanceMod = 1.0;

$pref::Audio::driver = "OpenAL";
$pref::Audio::forceMaxDistanceUpdate = 0;
$pref::Audio::environmentEnabled = 0;
$pref::Audio::usePlayerCentricListener = 0; // AFX
$pref::Audio::masterVolume   = 1.0;
$pref::Audio::channelVolume1 = 0.8;
$pref::Audio::channelVolume2 = 0.8;
$pref::Audio::channelVolume3 = 0.8;
$pref::Audio::channelVolume4 = 0.8;
$pref::Audio::channelVolume5 = 0.8;
$pref::Audio::channelVolume6 = 0.8;
$pref::Audio::channelVolume7 = 0.8;
$pref::Audio::channelVolume8 = 0.8;

$pref::OpenGL::gammaCorrection = 0.5;

$pref::LevelOfDetail = $Detail::High;
$pref::TextureManager::LowModelPrefix = "low_";
$pref::TextureManager::LowTerrainPrefix = "lowTerr_";
$pref::TextureManager::ModelMode = $TextureManager::High;
$pref::TextureManager::TerrainMode = $TextureManager::High;
$pref::Shadows::Available = true;
$pref::Shadows::Detail = $Detail::Medium;
$pref::Video::FirstDesktopDim = "";
$pref::Game::FirstTimePlaying = true;
